# ideas/permissions.py

from rest_framework import permissions

class IsAdmin(permissions.BasePermission):
    """
    دسترسی سفارشی برای اینکه فقط کاربران ادمین (is_staff) مجاز باشند.
    """
    def has_permission(self, request, view):
        # کاربر باید لاگین کرده باشد و یک کاربر staff (ادمین) باشد.
        return request.user and request.user.is_staff

class IsOwnerOrAdmin(permissions.BasePermission):
    """
    دسترسی سفارشی برای اینکه فقط مالک شیء یا ادمین بتواند آن را ویرایش کند.
    """
    def has_object_permission(self, request, view, obj):
        # دسترسی خواندن برای همه مجاز است.
        if request.method in permissions.SAFE_METHODS:
            return True

        # دسترسی نوشتن فقط برای مالک یا ادمین مجاز است.
        # ما چک می‌کنیم که شیء فیلد 'author' را داشته باشد.
        if hasattr(obj, 'author'):
            return obj.author == request.user or request.user.is_staff

        # برای مدل‌هایی مثل Attachment که شاید author نداشته باشند،
        # به نویسنده ایده اصلی دسترسی می‌دهیم.
        if hasattr(obj, 'idea') and hasattr(obj.idea, 'author'):
            return obj.idea.author == request.user or request.user.is_staff

        # اگر هیچکدام از شرایط بالا برقرار نبود، اجازه دسترسی نده.
        return False